import java.util.*;
import java.util.concurrent.*;

class PhaserAsCyclicBarrier {
	static final int SAMPLE_SIZE = 10_000;
	static final int N_SAMPLES = 10;
	static final int N_EXPERIMENTS = 5;
	static final double[] data = new double[N_SAMPLES];

	static final Phaser phaser = new Phaser(N_SAMPLES) {
		@Override
		protected boolean onAdvance(int phase, int registeredParties) {
			double sum = 0.0;
			double qs = 0.0;
			for(int i = 0; i < N_SAMPLES; i++) {
				sum += data[i];
				qs += data[i] * data[i];
			}
			double mean = sum / N_SAMPLES;
			double variance = (qs - N_SAMPLES *mean*mean) / (N_SAMPLES - 1); // Verschiebungsformel
			double se = Math.sqrt(variance);
			System.out.println("SE(" + phase + ") = " + se);
			return phase == N_EXPERIMENTS - 1;
		}
	};

	static class Meaner implements Runnable {
		private int col;
		private Random zzg = new Random();
		Meaner(int col) {
			this.col = col;
		}
		public void run() {
			while (!phaser.isTerminated()) {
				double mean = 0.0;
				for (int i = 0; i < SAMPLE_SIZE; i++)
					mean = mean + zzg.nextDouble();
				data[col] = mean / SAMPLE_SIZE;
				phaser.arriveAndAwaitAdvance();
			}
		}
	}

	public static void main(String[] args) {
		for (int i = 0; i < N_SAMPLES; i++)
			new Thread(new Meaner(i)).start();
	}
}
